<?php
/**
 * Widget Back Recent Posts
 *
 * @package Backframework
 * @author Back Theme
 * @link http://rstheme.com
 */

// Register and load the widget
function wpb_ticker_load_widget() {
    register_widget( 'backframework_recent_ticker_widget' );
}
add_action( 'widgets_init', 'wpb_ticker_load_widget' );
 
// Creating the widget 
class backframework_recent_ticker_widget extends WP_Widget {
 
function __construct() {
parent::__construct(
 
// Base ID of your widget
'ticker_wpb_widget', 
 
// Widget name will appear in UI
__('Back Ticker Post Widget', 'back-core-framework'), 
 
// Widget description
array( 'description' => __( 'Ticker post widget with different options', 'back-core-framework' ), ) 
);
}
 
// Creating widget front-end
 
public function widget( $args, $instance ) {
if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'Ticker Posts','back-core-framework' );

		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

		$number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 5;
		if ( ! $number )
			$number = 5;
		
		$back_best_post = new WP_Query( apply_filters( 'widget_posts_args', array(
			'posts_per_page'      => $number,
			'no_found_rows'       => true,
			'post_status'         => 'publish',
			'ignore_sticky_posts' => true
		)));?>

        <div class="back-ticker">
    		<?php
                if ($back_best_post->have_posts()) :
            ?>
            <?php if ( $title ) { ?>
              <?php echo wp_kses_post($args['before_title'] . $title . $args['after_title']); ?>
            <?php } ?>                    
            <div class="back__topber__slider">
                <?php 
                while ( $back_best_post->have_posts() ) : $back_best_post->the_post(); ?>
                    <div>
                        <div class="item"><span> <a href="<?php the_permalink(); ?>"><?php echo wp_trim_words( get_the_title(), 7 ); ?></a> </span></div>
                    </div>
                <?php 
                endwhile; 
                ?>
            </div>            
            <?php
                // Reset the global $the_post as this query will have stomped on it
                wp_reset_postdata();
                endif;
            ?>
        </div>

        <?php  
        }

// Updating widget replacing old instances with new
	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['number'] = (int) $new_instance['number'];
		return $instance;
}
         
// Widget Backend 
public function form( $instance ) {
	$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
	$number    = isset( $instance['number'] ) ? absint( $instance['number'] ) : 5;
?>
<p>
  <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>">
    <?php esc_html_e( 'Title:','back-core-framework' ); ?>
  </label>
  <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_js($title); ?>" />
</p>
<p>
  <label for="<?php echo esc_attr($this->get_field_id( 'number' )); ?>">
    <?php esc_html_e( 'Number of posts to show:','back-core-framework' ); ?>
  </label>
  <input class="tiny-text" id="<?php echo esc_attr($this->get_field_id( 'number' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'number' )); ?>" type="number" step="1" min="1" value="<?php echo esc_js($number); ?>" size="3" />
</p>

<?php
	}

} // Class wpb_widget ends here
