<?php /**
* Adds Back Social Icon Widget widget
*/
class back_followers_socia_Widget extends WP_Widget {

	/**
	* Register widget with WordPress
	*/
	function __construct() {
		parent::__construct(
			'back_followers_socia_Widget', // Base ID
			esc_html__( 'Back Follow Us', 'back' ), // Name
			array( 'description' => esc_html__( 'Back follow icon widget area', 'back' ), ) // Args
		);
	}

	/**
	* Widget Fields
	*/
	private $widget_fields = array(
		array(
			'label' => 'Facebook',
			'id' => 'facebook',
			'type' => 'text',
		),
		array(
			'label' => 'Facebook Follower Number',
			'id' => 'fb_follower_number',
			'type' => 'text',
		),
		array(
			'label' => 'Facebook Follower Text',
			'id' => 'fb_follower_text',
			'type' => 'text',
		),
		array(
			'label' => 'Twitter',
			'id' => 'twitter',
			'type' => 'text',
		),
		array(
			'label' => 'Twitter Follower Number',
			'id' => 'tw_follower_number',
			'type' => 'text',
		),
		array(
			'label' => 'Twitter Follower Text',
			'id' => 'tw_follower_text',
			'type' => 'text',
		),
		array(
			'label' => 'Pinterest',
			'id' => 'pinterest',
			'type' => 'text',
		),
		array(
			'label' => 'Pinterest Follower Number',
			'id' => 'pt_follower_number',
			'type' => 'text',
		),
		array(
			'label' => 'Pinterest Follower Text',
			'id' => 'pt_follower_text',
			'type' => 'text',
		),
		array(
			'label' => 'Linkedin',
			'id' => 'linkedin',
			'type' => 'text',
		),
		array(
			'label' => 'Linkedin Follower Number',
			'id' => 'ld_follower_number',
			'type' => 'text',
		),
		array(
			'label' => 'Linkedin Follower Text',
			'id' => 'ld_follower_text',
			'type' => 'text',
		),
		
		array(
			'label' => 'Instagram',
			'id' => 'instagram',
			'type' => 'text',
		),
		array(
			'label' => 'Instagram Follower Number',
			'id' => 'ig_follower_number',
			'type' => 'text',
		),
		array(
			'label' => 'Instagram Follower Text',
			'id' => 'ig_follower_text',
			'type' => 'text',
		),
		array(
			'label' => 'Youtube',
			'id' => 'youtube',
			'type' => 'text',
		),
		array(
			'label' => 'Youtube Follower Number',
			'id' => 'yt_follower_number',
			'type' => 'text',
		),
		array(
			'label' => 'Youtube Follower Text',
			'id' => 'yt_follower_text',
			'type' => 'text',
		),
		array(
			'label' => 'Tumblr',
			'id' => 'tumblr',
			'type' => 'text',
		),
		array(
			'label' => 'Tumblr Follower Number',
			'id' => 'tum_follower_number',
			'type' => 'text',
		),
		array(
			'label' => 'Tumblr Follower Text',
			'id' => 'tum_follower_text',
			'type' => 'text',
		),
		array(
			'label' => 'Vimeo',
			'id' => 'vimeo',
			'type' => 'text',
		),
		array(
			'label' => 'Vimeo Follower Number',
			'id' => 'vm_follower_number',
			'type' => 'text',
		),
		array(
			'label' => 'Vimeo Follower Text',
			'id' => 'vm_follower_text',
			'type' => 'text',
		),
	);

	/**
	* Front-end display of widget
	*/
	public function widget( $args, $instance ) {
		echo $args['before_widget'];

		// Output widget title
		if ( ! empty( $instance['title'] ) ) {
			echo wp_kses_post($args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title']);
		}?>
	
		<ul class="footer_social followus_share">  
		    <?php
		    
		    if(!empty($instance['facebook'])) { ?>
		        <li class="facebook"> 
			        <a href="<?php echo esc_url($instance['facebook'])?>" target="_blank">
			        	<span class="icon"><i class="ri-facebook-fill"></i></span> 
			        	<span class="number"><?php echo esc_html($instance['fb_follower_number'])?>
			        		<em><?php echo esc_html($instance['fb_follower_text'])?></em>
			        	</span>
			        </a> 
		        </li>
		    <?php } ?>

		    <?php if (!empty($instance['instagram'])) { ?>
		        <li class="instagram"> 
		        <a href="<?php  echo esc_url($instance['instagram']);?> " target="_blank"><span class="icon"> <i class="ri-instagram-line"></i> </span>
		        	<span class="number">
		        		<?php echo esc_html($instance['ig_follower_number'])?>
		        	<em><?php echo esc_html($instance['ig_follower_text'])?></em>
		        	</span>
		        </a> 
		        </li>
		    <?php } ?>

		    
		    <?php if (!empty($instance['youtube'])) { ?>
		        <li class="youtube"> 
		        <a href="<?php  echo esc_url($instance['youtube'])?> " target="_blank"><span class="icon"> <i class="ri-youtube-fill"></i> </span>
		        	<span class="number">
		        		<?php echo esc_html($instance['yt_follower_number'])?>
		        	<em><?php echo esc_html($instance['yt_follower_text'])?></em>
		        	</span></a> 
		        </li>
		    <?php } ?>

		    <?php if(!empty($instance['twitter'])) { ?>
		        <li class="twitter"> 
		        <a href="<?php echo esc_url($instance['twitter']);?> " target="_blank"><span class="icon"> <i class="ri-twitter-x-fill"></i> </span><span class="number"><?php echo esc_html($instance['tw_follower_number'])?>
		        <em><?php echo esc_html($instance['tw_follower_text'])?></em>
		    	</span> 
			    </a> 
		        </li>
		    <?php } ?>
		    
		    <?php if (!empty($instance['pinterest'])) { ?>
		        <li class="pinterest"> 
		        <a href="<?php  echo esc_url($instance['pinterest']);?> " target="_blank"><span class="icon"> <i class="ri-pinterest-line"></i> </span>
		        	<span class="number">
		        		<?php echo esc_html($instance['pt_follower_number'])?>
		        		<?php echo esc_html($instance['pt_follower_text'])?>
		        	</span>
		        </a> 
		        </li>
		    <?php } ?>
		    <?php if (!empty($instance['linkedin'])) { ?>
		        <li class="linkedin"> 
		        <a href="<?php  echo esc_url($instance['linkedin']);?> " target="_blank"><span class="icon"> <i class="ri-linkedin-fill"></i> </span>
		        	<span class="number"><?php echo esc_html($instance['ld_follower_number'])?>
		        	<em><?php echo esc_html($instance['ld_follower_text'])?></em>
		        	</span>
		        </a> 
		        </li>
		    <?php } ?>
		    <?php if(!empty($instance['vimeo'])) { ?>
		        <li class="vimeo"> 
		        <a href="<?php  echo esc_url($instance['vimeo'])?> " target="_blank"><span class="icon"> <i class="ri-vimeo-line"></i> </span>
		        	<span class="number"><?php echo esc_html($instance['vm_follower_number'])?>
		        	<em><?php echo esc_html($instance['vm_follower_text'])?></em>
		        </span></a> 
		        </li>
		    <?php } ?>
		    <?php if (!empty($instance['tumblr'])) { ?>
		        <li class="tumblr"> 
		        <a href="<?php  echo esc_url($instance['tumblr'])?> " target="_blank"><span class="icon"> <i class="ri-tumblr-fill"></i> </span>
		        <span class="number"><?php echo esc_html($instance['tum_follower_number'])?>
		        <em><?php echo esc_html($instance['tum_follower_text'])?></em>
		    </span></a> 
		        </li>
		    <?php } ?>     
		</ul><?php 
		
		echo wp_kses_post($args['after_widget']);
	}

	/**
	* Back-end widget fields
	*/
	public function field_generator( $instance ) {
		$output = '';
		foreach ( $this->widget_fields as $widget_field ) {
			$widget_value = ! empty( $instance[$widget_field['id']] ) ? $instance[$widget_field['id']] : esc_html__( isset($widget_field['default']), 'back' );
			switch ( $widget_field['type'] ) {
				default:
					$output .= '<p>';
					$output .= '<label for="'.esc_attr( $this->get_field_id( $widget_field['id'] ) ).'">'.esc_attr( $widget_field['label'], 'back' ).':</label> ';
					$output .= '<input class="widefat" id="'.esc_attr( $this->get_field_id( $widget_field['id'] ) ).'" name="'.esc_attr( $this->get_field_name( $widget_field['id'] ) ).'" type="'.$widget_field['type'].'" value="'.esc_attr( $widget_value ).'">';
					$output .= '</p>';
			}
		}
		echo $output;
	}

	public function form( $instance ) {
		$title = ! empty( $instance['title'] ) ? $instance['title'] : esc_html__( '', 'back' );
		?>
		<p>
		<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_attr_e( 'Title:', 'back' ); ?></label>
		<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
		</p>
		<?php
		$this->field_generator( $instance );
	}

	/**
	* Sanitize widget form values as they are saved
	*/
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		foreach ( $this->widget_fields as $widget_field ) {
			switch ( $widget_field['type'] ) {
				case 'checkbox':
					$instance[$widget_field['id']] = $_POST[$this->get_field_id( $widget_field['id'] )];
					break;
				default:
					$instance[$widget_field['id']] = ( ! empty( $new_instance[$widget_field['id']] ) ) ? strip_tags( $new_instance[$widget_field['id']] ) : '';
			}
		}
		return $instance;
	}
} // class back_followers_socia_Widget

// register back Social Icon Widget widget
function register_back_followers_socia_Widget() {
	register_widget( 'back_followers_socia_Widget' );
}
add_action( 'widgets_init', 'register_back_followers_socia_Widget' );